//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.IDf7db0410_29f3_4c8b_95b8_37fd4e7f2185
{
    public class Class_CRT_TV_scanline : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Image = 1,
            iTime = 2,
            FishEye = 3,
            ScanScale = 4,
            ScanAmp = 5,
            RGBSplit = 6
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Image = inputs[(int)InputId.Image].Eval(context).Image; // Needs to be checked for null!
            var iTime = inputs[(int)InputId.iTime].Eval(context).Value;
            var FishEye = inputs[(int)InputId.FishEye].Eval(context).Value;
            var ScanScale = inputs[(int)InputId.ScanScale].Eval(context).Value;
            var ScanAmp = inputs[(int)InputId.ScanAmp].Eval(context).Value;
            var RGBSplit = inputs[(int)InputId.RGBSplit].Eval(context).Value;
            //<<< _params

            return PrepareAndEvalOnChange(context, () => {
                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 0));

                //>>> _setup
                using (var ImageView = new ShaderResourceView(context.D3DDevice, Image))
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("Image").AsShaderResource().SetResource(ImageView);
                    _effect.GetVariableByName("iTime").AsScalar().Set(iTime);
                    _effect.GetVariableByName("FishEye").AsScalar().Set(FishEye);
                    _effect.GetVariableByName("ScanScale").AsScalar().Set(ScanScale);
                    _effect.GetVariableByName("ScanAmp").AsScalar().Set(ScanAmp);
                    _effect.GetVariableByName("RGBSplit").AsScalar().Set(RGBSplit);
                //<<< _setup

                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}



